//------------------------
// PARAMETERS

float4x4 gWorldViewProjMatrix
<
   string paramClass="intrinsic";
   string paramName="worldViewProj";
> = float4x4(1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1);

float4 gSunDir
<
   string paramClass="intrinsic";
   string paramName="sunDirection";
> = float4(0, 0, 1, 0);

float4 gModelSpaceCameraPos
<
   string paramClass="intrinsic";
   string paramName="modelSpaceCameraPos";
> = float4(0,0,0,1);

float4 gAmbientColor
<
  string paramClass="intrinsic";
  string paramName="ambientColor";
  string paramType="color";
> = float4(0, 0, 0, 0);

float4 gSunColor
<
  string paramClass="intrinsic";
  string paramName="sunColor";
  string paramType="color";  
> = float4(1, 1, 1, 1);

float4 gTintColor
<
  string paramClass="intrinsic";
  string paramName="flatColor";
  string paramType="color";
> = float4(0, 0, 0, 0);

float4 gPixelXFormColor
<
   string paramClass="param";
   string paramName="pixelxformColor";
   string paramType="color";
> = float4(1, 1, 1, 1);

sampler gSampler0 : register(s0);
sampler gSampler1 : register(s1);
sampler gSampler2 : register(s2);
sampler gSampler3 : register(s3);

// END PARAMETERS


//------------------------
// FUNCTION_VS bumpVS_sm2

attribute vec3 Tangent;

uniform mat4 gWorldViewProjMatrix;
uniform vec4 gSunDir;
uniform vec4 gModelSpaceCameraPos;

varying vec3 TangentSpaceSunDir;
varying vec3 TangentSpaceHalfVec;

void main()
{
	// Transform position
	gl_Position = gl_Vertex * gWorldViewProjMatrix;
	
	// Set tex coords.  Diffuse and bump map share same coords.
#ifdef CLIFF
    gl_TexCoord[0].st = gl_MultiTexCoord2.st;
#else
    gl_TexCoord[0].st = gl_MultiTexCoord0.st;
#endif
	
	// Compute binormal.
	// If tangent is halved in length, that means the binormal is flipped, so we
	// construct a negated binormal and rescale the tangent by 2.0.
	
	float tanLenSqr = dot(Tangent, Tangent);
	vec3 binormal;
	vec3 vTangent = Tangent;
	if( tanLenSqr < 0.3 )
	{
		// Rescale tangent.
		vTangent *= 2.0;
		
		// Flipped binormal.
		binormal = cross(-vTangent, gl_Normal);
	}
	else
	{
		// Standard binormal.
		binormal = -cross(-vTangent, gl_Normal);
	}
	vTangent = -vTangent;
	
	// Move sun direction into tangent space.
	TangentSpaceSunDir.x = dot(vTangent, gSunDir.xyz);
	TangentSpaceSunDir.y = dot(binormal, gSunDir.xyz);
	TangentSpaceSunDir.z = dot(gl_Normal, gSunDir.xyz);
	
	// Compute H vector.
	vec3 modelSpaceDirToCamera = normalize(gModelSpaceCameraPos.xyz - gl_Vertex.xyz);
	vec3 halfAngleVector = normalize(gSunDir.xyz + modelSpaceDirToCamera);

	// Move H vector into tangent space.
	TangentSpaceHalfVec.x = dot(vTangent, halfAngleVector);
	TangentSpaceHalfVec.y = dot(binormal, halfAngleVector);
	TangentSpaceHalfVec.z = dot(gl_Normal, halfAngleVector);
}


//------------------------
// FUNCTION_PS BumpPS_sm2

uniform sampler2D gSampler0;	// diffuse texture
uniform sampler2D gSampler1;	// bump (normal) map
uniform sampler2D gSampler3;	// specular map?

uniform vec4 gAmbientColor;
uniform vec4 gSunColor;
uniform vec4 gTintColor;
uniform vec4 gPixelXFormColor;

varying vec3 TangentSpaceSunDir;
varying vec3 TangentSpaceHalfVec;

const vec3 cOne = vec3(1.0, 1.0, 1.0);

void main()
{
	vec4 diffuseMap = texture2D(gSampler0, gl_TexCoord[0].st);
	vec4 normalMap = texture2D(gSampler1, gl_TexCoord[0].st);
	
	// Rescale to -1...1 range and swap a/r channels.
	vec3 norm = (normalMap.agb - 0.5) * 2.0;
	
	// -- lookup N.L / N.H
//	vec2 computedCoords;
//	computedCoords.x = clamp(dot(TangentSpaceSunDir, norm), 0.05, 0.95);
//	computedCoords.y = clamp(dot(TangentSpaceHalfVec, norm), 0.05, 0.95);

//	vec4 spec = texture2D(gSampler3, computedCoords);
float dotty = max( dot(norm, TangentSpaceSunDir), 0.0 );
vec4 spec = vec4( dotty, dotty, dotty, 0.0 );

	//	Diffuse color section
	
	//--  spec * sun + ambient
	vec3 OutColor = vec3( (spec * gSunColor) + gAmbientColor );

#if (!defined (SPEC) && !defined(PIXELXFORM))
	OutColor = OutColor * diffuseMap.rgb * 2.0;
#else
	OutColor = OutColor * diffuseMap.rgb;
#endif

	vec3 tempColor;
#if (defined(PIXELXFORM) && defined(SPEC))
   //-- Modulate by white or pixelxform color based on Diffuse Alpha
   tempColor = mix( gPixelXFormColor.rgb, cOne, diffuseMap.a );
   OutColor = tempColor * OutColor;
#endif

#if (defined(PIXELXFORM) && !defined(SPEC))
   //-- Modulate by white or pixelxform color based on Diffuse Alpha
   tempColor = mix( gPixelXFormColor.rgb, cOne, diffuseMap.a );
   OutColor = tempColor * OutColor * 2.0;
#endif

  //-- Get specular and modulate by sun Color
#if (defined(SPEC) && defined(SPECMASK))
	tempColor = spec.a * gSunColor.rgb;

	//-- modulate specular by gloss map
	tempColor = tempColor * normalMap.a;

	//-- add in specular
	OutColor = (OutColor + tempColor) * 2.0;
#endif

#if (defined(SPEC) && !defined(SPECMASK))
	tempColor = spec.a * gSunColor.rgb;

	//-- add in specular
	OutColor = (OutColor + tempColor) * 2.0;
#endif

#ifdef TINT
	//-- add tint
	OutColor += gTintColor.rgb;
#endif

#ifdef CLIFF
	OutColor = (spec.rgb * gSunColor.rgb) + gAmbientColor.rgb;
	OutColor *= diffuseMap.rgb * 2.0;
#endif


	//	Alpha section

#if defined(OVERALL_ALPHA) && defined(ALPHATEST)
	// Use diffuse texture's alpha value * overall alpha
	gl_FragColor = vec4( OutColor, diffuseMap.a * gTintColor.a );
#endif

#if defined(OVERALL_ALPHA) && !defined(ALPHATEST)
	// Use overall alpha only
	gl_FragColor = vec4( OutColor, gTintColor.a );
#endif

#if !defined(OVERALL_ALPHA) && defined(OUTPUT_SPEC_TO_ALPHA) && defined(ALPHATEST)
	//-- just output diffuse map alpha for testing purposes
	//-- we don't allow blooming of alphatested things
	gl_FragColor = vec4( OutColor, diffuseMap.a );
#endif

#if !defined(OVERALL_ALPHA) && defined(OUTPUT_SPEC_TO_ALPHA) && !defined(ALPHATEST) && defined(SPEC) && defined(SPECMASK)
	gl_FragColor = vec4(OutColor, normalMap.a );            
#endif

#if !defined(OVERALL_ALPHA) && defined(OUTPUT_SPEC_TO_ALPHA) && !defined(ALPHATEST) && defined(SPEC) && !defined(SPECMASK)
	gl_FragColor = vec4(OutColor, spec.a );            
#endif

#if !defined(OVERALL_ALPHA) && defined(OUTPUT_SPEC_TO_ALPHA) && !defined(ALPHATEST) && !defined(SPEC)
	gl_FragColor = vec4(OutColor, 0.0 );            
#endif
	
#if !defined(OVERALL_ALPHA) && !defined(OUTPUT_SPEC_TO_ALPHA) && defined(ALPHATEST)
	// Use diffuse texture's alpha value if bump alphatest used
	gl_FragColor = vec4( OutColor, diffuseMap.a );
#endif
	
#if !defined(OVERALL_ALPHA) && !defined(OUTPUT_SPEC_TO_ALPHA) && !defined(ALPHATEST)
	// No alpha
	gl_FragColor = vec4( OutColor, 1.0 );
#endif
} 


//-----------------------------
// FUNCTION_VS BumpDecalVS_sm2

attribute vec3 Tangent;

uniform mat4 gWorldViewProjMatrix;
uniform vec4 gSunDir;

varying vec3 TangentSpaceSunDir;

const vec2 gMagicScalar = vec2( 0.0625, -0.0625 );

void main()
{
	vec3 tempColor;
	
	// Transform position
	gl_Position = gl_Vertex * gWorldViewProjMatrix;
	
	// Send vertex color
	gl_FrontColor = gl_Color;

#ifdef TERRAINDIFFUSE
	// Generate coordinates that match terrain
   gl_TexCoord[0].st = gl_Position.xz * gMagicScalar;
#else
	// Use decal coordinates
    gl_TexCoord[0].st = gl_MultiTexCoord0.st;
#endif

	// use decal coordinates for bump
    gl_TexCoord[1].st = gl_MultiTexCoord0.st;
	
	// cross prod to generate binormal in model space -- "w"
	tempColor = gl_Normal.zxy * Tangent.yzx;
	vec3 binormal = (gl_Normal.yzx * Tangent.zxy) - tempColor;

	// transform the light vector by the resulting matrix to get the light dir in tan space
	TangentSpaceSunDir.x = dot( -binormal, gSunDir.xyz );
	TangentSpaceSunDir.y = dot( Tangent, gSunDir.xyz );
	TangentSpaceSunDir.z = dot( gl_Normal, gSunDir.xyz );
}


//-----------------------------
// FUNCTION_PS BumpDecalPS_sm2

uniform sampler2D gSampler0;	// diffuse texture
uniform sampler2D gSampler1;	// bump (normal) map

uniform vec4 gAmbientColor;
uniform vec4 gSunColor;
uniform vec4 gTintColor;

varying vec3 TangentSpaceSunDir;

void main()
{
	// get diffuse texture pixel
	vec4 diffuseMap = texture2D(gSampler0, gl_TexCoord[0].st);

	// Swizzle alpha and red of bump pixel
	vec4 normalMap = texture2D(gSampler1, gl_TexCoord[1].st);

	// Rescale to -1...1 range and swap a/r channels.
	vec3 norm = (normalMap.agb - 0.5) * 2.0;
	
	// Diffuse lighting -- N dot L
	float NdotL = max( dot(norm, TangentSpaceSunDir), 0.0 );
	
	// n dot l squared seems to look nicer
	NdotL *= NdotL;

	//-- compute sun contribution and add in ambient
	vec3 temp = (NdotL * gSunColor.rgb) + (gAmbientColor.rgb * 0.75);

	// modulate by diffuse texture
	temp *= diffuseMap.rgb;
	temp *= 2.0;

#ifdef TERRAINDIFFUSE
	// Use alpha from bump texture (times vertex alpha)
	float alpha = normalMap.a * gl_Color.a;
#else
	// Use alpha from diffuse texture (times vertex alpha)
	float alpha = diffuseMap.a * gl_Color.a;
#endif

	//-- overall alpha
	alpha *= gTintColor.a;

	gl_FragColor = vec4( temp, alpha );
}


//-------------------------------
// FUNCTION_PS terrainBumpPS_sm2

uniform sampler2D gSampler0;	// diffuse texture
uniform sampler2D gSampler1;	// mask texture
uniform sampler2D gSampler2;	// bump (normal) map

uniform vec4 gAmbientColor;
uniform vec4 gSunColor;
uniform vec4 gTintColor;

varying vec3 TangentSpaceSunDir;
varying vec3 TangentSpaceHalfVec;

void main()
{
	vec4 diffuseMap = texture2D(gSampler0, gl_TexCoord[0].st);
#ifdef BLEND
	vec4 maskMap = texture2D(gSampler1, gl_TexCoord[0].st);
#endif

	// Swizzle alpha and red of bump pixel
	vec4 normalMap = texture2D(gSampler2, gl_TexCoord[0].st);

	// Rescale to -1...1 range and swap a/r channels.
	vec3 norm = (normalMap.agb - 0.5) * 2.0;
	
	// N dot L
	float NdotL = max( dot(norm, TangentSpaceSunDir), 0.0 );
	NdotL *= NdotL; // n dot l squared looks cooler

	// modulate sun color by the bump and add ambient
	vec3 OutColor = (NdotL * gSunColor.rgb) + (gAmbientColor.rgb * 0.75);

	// modulate by diffuse texture.
	OutColor *= diffuseMap.rgb;

#ifdef SPEC
   // Specular -- H vector dot sun
   vec3 spec = max( dot(norm, TangentSpaceHalfVec), 0.0 );
   //-- modulate by gloss map
   spec *= normalMap.a;
   //-- modulate by sunColor
   spec *= gSunColor.rgb;
   //-- power up spec
   spec *= spec;
   //-- add specular component
   OutColor += spec;
#endif
   //-- overbright
   OutColor *= 2.0;

#ifdef BLEND
	gl_FragColor = vec4( OutColor, 1.0 - maskMap.a );
#else
	gl_FragColor = vec4( OutColor, 1.0 );
#endif

#ifdef OVERALLALPHA
	gl_FragColor.a *= gTintColor.a;
#endif
}
